### Code for paper "On the Role of Minimum Variances in the Construction and Evaluation of Weighted Optimal Designs"
### Purpose is to read in .csv files produced by .jsl simulations
# in order to produce rho values from weighted A-optimal designs in
# paper Sections 4.1 and 4.2
# code runs in seconds, nothing needs to be changed, except
# file path to idb_df.csv, quad_df.csv, and quad_dfDN.csv may need updating

#### Section 4.1, IBD Example------------

# Read in data
VARIBD <- read.csv("ibd_df.csv", header = TRUE)[, 3:21]

minMatME <- matrix(ncol = 2, nrow = 50)
# Check which design across those generated
# Leads to minimum A_W value across weights


q = 1:50

meIBDwtM = q*0.9996/(5*q + 10)
fiIBDwtM = 0.9996/(5*q + 10)


### Find min for emphasis on main effects
for(i in 1:50) {
  w      = c(0, meIBDwtM[i], meIBDwtM[i], meIBDwtM[i], meIBDwtM[i], meIBDwtM[i], 
             0, 0, 0, fiIBDwtM[i], fiIBDwtM[i], fiIBDwtM[i], fiIBDwtM[i], fiIBDwtM[i],
             fiIBDwtM[i], fiIBDwtM[i], fiIBDwtM[i], fiIBDwtM[i], fiIBDwtM[i])
  A      = apply(VARIBD, 1, function(x) sum(w*x^2))
  minMatME[i, ] = (c(i, which(A == min(A))[1]))
}

minMatI <- matrix(ncol = 2, nrow = 50)

meIBDwtF = 0.9996/(5 + 10*q)
fiIBDwtF = q*0.9996/(5 + 10*q)

# Find min for emphasis on two-factor interaction effects
for(i in 2:50) {
  w      = c(0, meIBDwtF[i], meIBDwtF[i], meIBDwtF[i], meIBDwtF[i], meIBDwtF[i], 
             0, 0, 0, fiIBDwtF[i], fiIBDwtF[i], fiIBDwtF[i], fiIBDwtF[i], fiIBDwtF[i],
             fiIBDwtF[i], fiIBDwtF[i], fiIBDwtF[i], fiIBDwtF[i], fiIBDwtF[i])
  A      = apply(VARIBD[c(51:99),], 1, function(x) sum(w*x^2))
  minMatI[i, ] = (c(i+49, (which(A == min(A))[1] + 50)))
}


VARIBD_MIN <- VARIBD[c(minMatME[ , 2], minMatI[ , 2]), c(2:6, 10:19)]

# Calculate min/mean/max rho values
# for main effects
VARIBD_MIN[, 16] <- apply(VARIBD_MIN[1:5], 1, function(x) min(x^2/0.04166667))
VARIBD_MIN[, 17] <- apply(VARIBD_MIN[1:5], 1, function(x) mean(x^2/0.04166667))
VARIBD_MIN[, 18] <- apply(VARIBD_MIN[1:5], 1, function(x) max(x^2/0.04166667))

## Two-factor interaction effects
VARIBD_MIN[, 19] <- apply(VARIBD_MIN[6:15], 1, function(x) min(x^2/0.04166667))
VARIBD_MIN[, 20] <- apply(VARIBD_MIN[6:15], 1, function(x) mean(x^2/0.04166667))
VARIBD_MIN[, 21] <- apply(VARIBD_MIN[6:15], 1, function(x) max(x^2/0.04166667))


## Round all to 2 decimal places
VARIBD_MIN <- round(VARIBD_MIN, 2)
colnames(VARIBD_MIN) <- c(colnames(VARIBD_MIN[, 1:15]), "min ME rho", "mean ME rho","max ME rho",
                        "min I rho", "mean I rho", "max I rho") 
# Write .csv file
write.csv(VARIBD_MIN, file = "ibd_dfres.csv")

#### Section 4.2, Continuous Example------

VARC <- read.csv("quad_df.csv", header = TRUE)[, 3:12]

minMat <- matrix(ncol = 2, nrow = 50)

a = q*0.9999/(3*q + 6)
b = 0.9999/(3*q + 6)

aME = a/0.09
b2fi = b/0.10
bquad = b/0.33

# Check which design is min
for(i in 1:50) {
  w      = c(0, aME[i], aME[i], aME[i], b2fi[i], b2fi[i], b2fi[i], 
             bquad[i], bquad[i], bquad[i])
  A      = apply(VARC, 1, function(x) sum(w*x^2))
  print( which(A == min(A)))
  minMat[i, ] = (c(i, which(A == min(A))[1]))
}

VARC_MIN <- VARC[c(minMat[ , 2]), 2:10]

# Calculate min/mean/max rho values
# Main effects
VARC_MIN[, 10] <- apply(VARC_MIN[1:3], 1, function(x) min(x^2/0.09))
VARC_MIN[, 11] <- apply(VARC_MIN[1:3], 1, function(x) mean(x^2/0.09))
VARC_MIN[, 12] <- apply(VARC_MIN[1:3], 1, function(x) max(x^2/0.09))

## Two-factor interaction effects
VARC_MIN[, 13] <- apply(VARC_MIN[4:6], 1, function(x) min(x^2/0.1))
VARC_MIN[, 14] <- apply(VARC_MIN[4:6], 1, function(x) mean(x^2/0.1))
VARC_MIN[, 15] <- apply(VARC_MIN[4:6], 1, function(x) max(x^2/0.1))

## Quadratic effects
VARC_MIN[, 16] <- apply(VARC_MIN[7:9], 1, function(x) min(x^2/0.33))
VARC_MIN[, 17] <- apply(VARC_MIN[7:9], 1, function(x) mean(x^2/0.33))
VARC_MIN[, 18] <- apply(VARC_MIN[7:9], 1, function(x) max(x^2/0.33))


## Round all to 2 decimal places
VARC_MIN <- round(VARC_MIN, 2)
colnames(VARC_MIN) <- c(colnames(VARC_MIN[, 1:9]), "min ME rho", "mean ME rho","max ME rho",
                         "min I rho", "mean I rho", "max I rho",
                         "min Q rho", "mean Q rho", "max Q rho") 
# write .csv file
write.csv(VARC_MIN, file = "quad_Cres.csv")


#### Section 4.2, Discrete Example-----------

VARDN <- read.csv("quad_dfDN.csv", header = TRUE)[, 3:12]

minMat <- matrix(ncol = 2, nrow = 50)
# Check which design is minimum for each weight
for(i in 1:50) {
  w      = c(0, aME[i], aME[i], aME[i], b2fi[i], b2fi[i], b2fi[i], 
             bquad[i], bquad[i], bquad[i])
  A      = apply(VARDN, 1, function(x) sum(w*x^2))
  print(which(A == min(A)))
  minMat[i, ] = (c(i, which(A == min(A))[1]))
}

VARDN_MIN <- VARDN[c(minMat[ , 2]), 2:10]

# calculate min/mean/max rho values
# Main effects
VARDN_MIN[, 10] <- apply(VARDN_MIN[1:3], 1, function(x) min(x^2/0.09))
VARDN_MIN[, 11] <- apply(VARDN_MIN[1:3], 1, function(x) mean(x^2/0.09))
VARDN_MIN[, 12] <- apply(VARDN_MIN[1:3], 1, function(x) max(x^2/0.09))

## Two-factor interaction effects
VARDN_MIN[, 13] <- apply(VARDN_MIN[4:6], 1, function(x) min(x^2/0.1))
VARDN_MIN[, 14] <- apply(VARDN_MIN[4:6], 1, function(x) mean(x^2/0.1))
VARDN_MIN[, 15] <- apply(VARDN_MIN[4:6], 1, function(x) max(x^2/0.1))

## Quadratic effects
VARDN_MIN[, 16] <- apply(VARDN_MIN[7:9], 1, function(x) min(x^2/0.33))
VARDN_MIN[, 17] <- apply(VARDN_MIN[7:9], 1, function(x) mean(x^2/0.33))
VARDN_MIN[, 18] <- apply(VARDN_MIN[7:9], 1, function(x) max(x^2/0.33))


## Round all to 2 decimal places
VARDN_MIN <- round(VARDN_MIN, 2)
colnames(VARDN_MIN) <- c(colnames(VARDN_MIN[, 1:9]), "min ME rho", "mean ME rho","max ME rho",
                                  "min I rho", "mean I rho", "max I rho",
                                  "min Q rho", "mean Q rho", "max Q rho") 
# Write .csv file
  write.csv(VARDN_MIN, file = "quad_DNres.csv")